<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output omit-xml-declaration="true" method="html" indent="no"/>
<!-- 	This is a generic stylesheet used many times by the MyDetails page.
	Its main purpose is to output table rows of checkbox items 
	whose text values and parameter id values are in the xml being
	processed. 
	
	The main template is named "doRows" and is called with 
	a parameter named 'maintag' which contains the name of the 
	tag carrying the ID and description info (e.g., "LANGUAGE"). 

	The data is assumed to be in a form consistent with other Alkindi 
	XML lookups, where the main tag has ID and Description child tags
	named "XXX_ID" and "XXX_DESC", where XXX stands for the main
	tag's name (e.g., "LANGUAGE_ID" and "LANGUAGE_DESC").

	The checkboxes are output 3 to a row. 

	An item named "Other" will also get a text input box named
	"XXX_Other", where XXX is again the value of 'maintag' passed to the
	first template.
	
	

-->
<!--	Root level parameter for the name of the checkbox
-->
<xsl:param name="checkboxname" select="'default'"/>

<xsl:template name="doRows">
	<xsl:param name="maintag"/>

	<!-- Output a new row for every third 'maintag' node.
	-->
	<xsl:for-each select="$maintag[position() mod 3 = 1]">
		<tr valign="top"> 
			<!-- Output a checkbox item for the three 'maintag' nodes.
			-->
			<xsl:for-each select=". | (following-sibling::*[position() &lt; 3])">
				<xsl:call-template name="doCheckbox">
				</xsl:call-template>
			</xsl:for-each>
		</tr>
	</xsl:for-each>

</xsl:template>

<xsl:template name="doCheckbox">
	<xsl:variable name="descTagName" select="concat(name(), '_DESC')" />
	<xsl:variable name="idTagName" select="concat(name(), '_ID')" />
	<xsl:variable name = "otherTextInputName" select="concat(name(), '_Other')" />
		<td> <font face="Arial, Helvetica, sans-serif" size="2"> 
		<input type="checkbox">
			<xsl:attribute name="name"><xsl:value-of select="$checkboxname"/></xsl:attribute>
			<xsl:attribute name="value">
				<xsl:value-of select="descendant::*[name() = $idTagName]"/>
			</xsl:attribute>	
		</input>
		</font></td>
		<td width="150">
			<font face="Arial, Helvetica, sans-serif" size="2">
				<xsl:for-each select="descendant::*[name()= $descTagName]">
					<xsl:value-of select="." />
					<!-- Add text input to 'other' option -->
					<xsl:if test=". = 'Other'">
						&#160;<input type="text"  value="" size="10" maxlength="50">
							<xsl:attribute name="name">
								<xsl:value-of select="$otherTextInputName"/>
							</xsl:attribute>
						</input>
					</xsl:if>
				</xsl:for-each>
			</font>
		</td>
	
</xsl:template>

</xsl:stylesheet>
